typedef unsigned char cfg_u8;
typedef union {
    struct {
        cfg_u8 offset;
        cfg_u8 value;
    };
    struct {
        cfg_u8 command;
        cfg_u8 param;
    };
} cfg_reg;

#define CFG_META_SWITCH (255)
#define CFG_META_DELAY  (254)
#define CFG_META_BURST  (253)

/* Example C code */
/*
    // Externally implemented function that can write n-bytes to the device
    // PCM51xx and TAS5766 targets require the high bit (0x80) of the I2C register to be set on multiple writes.
    // Refer to the device data sheet for more information.
    extern int i2c_write(unsigned char *data, int n);
    // Externally implemented function that delays execution by n milliseconds
    extern int delay(int n);
    // Example implementation.  Call like:
    //     transmit_registers(registers, sizeof(registers)/sizeof(registers[0]));
    void transmit_registers(cfg_reg *r, int n)
    {
        int i = 0;
        while (i < n) {
            switch (r[i].command) {
            case CFG_META_SWITCH:
                // Used in legacy applications.  Ignored here.
                break;
            case CFG_META_DELAY:
                delay(r[i].param);
                break;
            case CFG_META_BURST:
                i2c_write((unsigned char *)&r[i+1], r[i].param);
                i += (r[i].param + 1)/2;
                break;
            default:
                i2c_write((unsigned char *)&r[i], 2);
                break;
            }
            i++;
        }
    }
 */

cfg_reg registers[] = {
// Command Dump Configuration
//-------------------------------------------------
// Project: PurePath� Smart Amp for Laptops
// SA Plug-in Version: TAS5766MDCAEVM v4.0010
// Block: Reset
// Version: 20141008
//-------------------------------------------------
//
//-------------------------------------------------
// Reset
//-------------------------------------------------
// Select Page 0
    { 0x00, 0x00 },
// Set the device into Powerdown
    { 0x02, 0x11 },
// Reset Device
    { 0x01, 0x11 },
// Command Dump Configuration
//-------------------------------------------------
// Project: PurePath� Smart Amp for Laptops
// SA Plug-in Version: TAS5766MDCAEVM v4.0010
// Block: Sleep
// Version: 20141008
//-------------------------------------------------
//
//-------------------------------------------------
// Sleep
//-------------------------------------------------
// Select Page 0
    { 0x00, 0x00 },
// Mute Left and Right Channels
    { 0x03, 0x11 },
// Set the device into Standby
    { 0x02, 0x10 },
// Command Dump Configuration
//-------------------------------------------------
// Project: PurePath� Smart Amp for Laptops
// SA Plug-in Version: TAS5766MDCAEVM v4.0010
// Block: I-RAM
// Version: 20141008
//-------------------------------------------------
//
//-------------------------------------------------
// Begin I-RAM_D Dump
//-------------------------------------------------
// Instruction Memory
// page 152 (0x98)
    { 0x00, 0x98 },
    { CFG_META_BURST, 0x79 },
        { 0x08, 0x00 },
        { 0x10, 0x00 },
        { 0x00, 0x00 },
        { 0x10, 0x04 },
        { 0x01, 0x00 },
        { 0x60, 0x03 },
        { 0xFB, 0x01 },
        { 0x00, 0x20 },
        { 0x09, 0x00 },
        { 0x70, 0x20 },
        { 0x05, 0x00 },
        { 0x40, 0x04 },
        { 0x08, 0x01 },
        { 0x10, 0x04 },
        { 0x01, 0x01 },
        { 0x10, 0x00 },
        { 0x01, 0x00 },
        { 0x40, 0xDC },
        { 0x07, 0x00 },
        { 0x60, 0x0C },
        { 0x05, 0x00 },
        { 0x70, 0x0C },
        { 0x07, 0x00 },
        { 0x70, 0x20 },
        { 0x08, 0x00 },
        { 0x60, 0x0C },
        { 0x07, 0x00 },
        { 0x40, 0x04 },
        { 0x04, 0x00 },
        { 0x80, 0x18 },
        { 0x01, 0x00 },
        { 0x40, 0x04 },
        { 0x06, 0x00 },
        { 0x60, 0x18 },
        { 0x06, 0x00 },
        { 0x60, 0x17 },
        { 0xFB, 0x00 },
        { 0x60, 0x0C },
        { 0x08, 0x01 },
        { 0x10, 0x14 },
        { 0x02, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x01 },
        { 0x10, 0x00 },
        { 0x02, 0x00 },
        { 0x40, 0x04 },
        { 0x06, 0x00 },
        { 0x40, 0x04 },
        { 0x04, 0x00 },
        { 0x60, 0x0C },
        { 0x0E, 0x00 },
        { 0x60, 0x0C },
        { 0x13, 0x00 },
        { 0x60, 0x08 },
        { 0x00, 0x00 },
        { 0x40, 0x04 },
        { 0x0D, 0x00 },
        { 0x40, 0x04 },
        { 0x12, 0x00 },
        { 0x80, 0x18 },
        { 0x0F, 0x00 },
// page 153 (0x99)
    { 0x00, 0x99 },
    { CFG_META_BURST, 0x79 },
        { 0x08, 0x00 },
        { 0x60, 0x18 },
        { 0x0C, 0x00 },
        { 0x60, 0x0C },
        { 0x04, 0x00 },
        { 0x60, 0x08 },
        { 0x01, 0x01 },
        { 0x10, 0x14 },
        { 0x01, 0x01 },
        { 0x10, 0x00 },
        { 0x01, 0x00 },
        { 0x40, 0x04 },
        { 0x0D, 0x00 },
        { 0x80, 0x18 },
        { 0x0F, 0x00 },
        { 0x60, 0x18 },
        { 0x11, 0x00 },
        { 0x60, 0x0C },
        { 0x04, 0x00 },
        { 0x63, 0x90 },
        { 0x0D, 0x01 },
        { 0x10, 0x14 },
        { 0x01, 0x01 },
        { 0x10, 0x00 },
        { 0x01, 0x00 },
        { 0x40, 0x04 },
        { 0x12, 0x00 },
        { 0x80, 0x1C },
        { 0x00, 0x00 },
        { 0x60, 0x1C },
        { 0x00, 0x00 },
        { 0x63, 0x90 },
        { 0x12, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x40, 0x18 },
        { 0x0A, 0x00 },
        { 0x80, 0x1C },
        { 0x00, 0x00 },
        { 0x60, 0x1C },
        { 0x01, 0x00 },
        { 0x60, 0x0C },
        { 0x0A, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x40, 0x18 },
        { 0x0F, 0x00 },
        { 0x40, 0xFC },
        { 0x0A, 0x00 },
        { 0x60, 0x0C },
        { 0x0F, 0x00 },
        { 0x60, 0x0C },
        { 0x00, 0x00 },
        { 0x60, 0x0C },
        { 0x01, 0x00 },
        { 0x40, 0xFC },
        { 0x0F, 0x00 },
        { 0x40, 0x04 },
        { 0x0B, 0x00 },
        { 0x40, 0x04 },
        { 0x10, 0x00 },
// page 154 (0x9A)
    { 0x00, 0x9A },
    { CFG_META_BURST, 0x79 },
        { 0x08, 0x00 },
        { 0x60, 0x10 },
        { 0x0A, 0x00 },
        { 0x63, 0x9C },
        { 0x16, 0x01 },
        { 0xB3, 0x98 },
        { 0x15, 0x01 },
        { 0x33, 0x94 },
        { 0x14, 0x01 },
        { 0xB3, 0xA0 },
        { 0x18, 0x00 },
        { 0x73, 0xA4 },
        { 0x19, 0x00 },
        { 0x60, 0x10 },
        { 0x0F, 0x00 },
        { 0x63, 0x9C },
        { 0x1C, 0x00 },
        { 0x40, 0x00 },
        { 0x17, 0x01 },
        { 0x33, 0x94 },
        { 0x1A, 0x01 },
        { 0xB3, 0x98 },
        { 0x1B, 0x01 },
        { 0xB3, 0xA0 },
        { 0x1E, 0x00 },
        { 0x73, 0xA4 },
        { 0x1F, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x40, 0x00 },
        { 0x1D, 0x00 },
        { 0x60, 0x0C },
        { 0x17, 0x00 },
        { 0x70, 0x0C },
        { 0x1D, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x40, 0x04 },
        { 0x20, 0x00 },
        { 0x60, 0x10 },
        { 0x0A, 0x00 },
        { 0x63, 0xB0 },
        { 0x23, 0x01 },
        { 0xB3, 0xAC },
        { 0x22, 0x01 },
        { 0x33, 0xA8 },
        { 0x21, 0x01 },
        { 0xB3, 0xB4 },
        { 0x25, 0x00 },
        { 0x73, 0xB8 },
        { 0x26, 0x00 },
        { 0x60, 0x10 },
        { 0x0F, 0x00 },
        { 0x63, 0xB0 },
        { 0x29, 0x00 },
        { 0x40, 0x00 },
        { 0x24, 0x00 },
// page 155 (0x9B)
    { 0x00, 0x9B },
    { CFG_META_BURST, 0x79 },
        { 0x08, 0x01 },
        { 0x33, 0xA8 },
        { 0x27, 0x01 },
        { 0xB3, 0xAC },
        { 0x28, 0x01 },
        { 0xB3, 0xB4 },
        { 0x2B, 0x00 },
        { 0x73, 0xB8 },
        { 0x2C, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x40, 0x00 },
        { 0x2A, 0x00 },
        { 0x63, 0xBC },
        { 0x24, 0x00 },
        { 0x73, 0xC0 },
        { 0x20, 0x00 },
        { 0x63, 0xBC },
        { 0x2A, 0x00 },
        { 0x73, 0xC0 },
        { 0x20, 0x00 },
        { 0x40, 0x00 },
        { 0x2D, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x40, 0x00 },
        { 0x2E, 0x00 },
        { 0x21, 0xF0 },
        { 0x0A, 0x00 },
        { 0x21, 0xEC },
        { 0x0B, 0x00 },
        { 0x60, 0x0C },
        { 0x2D, 0x01 },
        { 0x20, 0x78 },
        { 0x00, 0x01 },
        { 0x20, 0x7C },
        { 0x00, 0x01 },
        { 0x14, 0x82 },
        { 0xBE, 0x00 },
        { 0x21, 0xF0 },
        { 0x45, 0x00 },
        { 0x60, 0x0C },
        { 0x2E, 0x01 },
        { 0x20, 0x78 },
        { 0x00, 0x01 },
        { 0x20, 0x7C },
        { 0x00, 0x01 },
        { 0x14, 0x82 },
        { 0xBE, 0x00 },
        { 0x21, 0xEC },
        { 0x47, 0x00 },
        { 0x21, 0xF0 },
        { 0x46, 0x00 },
        { 0x60, 0x0C },
        { 0x4E, 0x01 },
        { 0x20, 0x78 },
        { 0x00, 0x01 },
        { 0x20, 0x7C },
        { 0x00, 0x00 },
// page 156 (0x9C)
    { 0x00, 0x9C },
    { CFG_META_BURST, 0x79 },
        { 0x08, 0x01 },
        { 0x14, 0x82 },
        { 0xB4, 0x00 },
        { 0x21, 0xF0 },
        { 0x48, 0x00 },
        { 0x60, 0x0C },
        { 0x70, 0x01 },
        { 0x20, 0x78 },
        { 0x00, 0x01 },
        { 0x20, 0x7C },
        { 0x00, 0x01 },
        { 0x14, 0x82 },
        { 0xB4, 0x00 },
        { 0x60, 0x0C },
        { 0x83, 0x00 },
        { 0x61, 0x50 },
        { 0x9B, 0x01 },
        { 0xB1, 0x4C },
        { 0x9A, 0x00 },
        { 0x40, 0x04 },
        { 0x99, 0x00 },
        { 0x71, 0x48 },
        { 0x99, 0x01 },
        { 0xB1, 0x54 },
        { 0x9D, 0x00 },
        { 0x71, 0x58 },
        { 0x9E, 0x00 },
        { 0x61, 0x64 },
        { 0x9E, 0x01 },
        { 0xB1, 0x60 },
        { 0x9D, 0x01 },
        { 0x31, 0x5C },
        { 0x9C, 0x01 },
        { 0xB1, 0x68 },
        { 0xA0, 0x00 },
        { 0x71, 0x6C },
        { 0xA1, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x40, 0x00 },
        { 0x9F, 0x00 },
        { 0x60, 0x0C },
        { 0x96, 0x00 },
        { 0x61, 0x50 },
        { 0xA4, 0x01 },
        { 0xB1, 0x4C },
        { 0xA3, 0x00 },
        { 0x40, 0x04 },
        { 0xA2, 0x00 },
        { 0x71, 0x48 },
        { 0xA2, 0x01 },
        { 0xB1, 0x54 },
        { 0xA6, 0x00 },
        { 0x71, 0x58 },
        { 0xA7, 0x00 },
        { 0x61, 0x64 },
        { 0xA7, 0x01 },
        { 0xB1, 0x60 },
        { 0xA6, 0x00 },
// page 157 (0x9D)
    { 0x00, 0x9D },
    { CFG_META_BURST, 0x79 },
        { 0x08, 0x01 },
        { 0x31, 0x5C },
        { 0xA5, 0x01 },
        { 0xB1, 0x68 },
        { 0xA9, 0x00 },
        { 0x71, 0x6C },
        { 0xAA, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x40, 0x00 },
        { 0xA8, 0x00 },
        { 0x61, 0x44 },
        { 0x9F, 0x00 },
        { 0x61, 0x44 },
        { 0xA8, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x40, 0x10 },
        { 0xAB, 0x00 },
        { 0x40, 0x10 },
        { 0xAC, 0x00 },
        { 0x60, 0x10 },
        { 0xAB, 0x00 },
        { 0x70, 0x08 },
        { 0x83, 0x00 },
        { 0x60, 0x10 },
        { 0xAC, 0x00 },
        { 0x70, 0x08 },
        { 0x96, 0x00 },
        { 0x40, 0x00 },
        { 0xAD, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x40, 0x00 },
        { 0xAE, 0x00 },
        { 0xC1, 0x24 },
        { 0xAD, 0x00 },
        { 0x71, 0x28 },
        { 0xB3, 0x00 },
        { 0xC1, 0x24 },
        { 0xAE, 0x00 },
        { 0x71, 0x28 },
        { 0xB6, 0x00 },
        { 0x40, 0x00 },
        { 0xB2, 0x00 },
        { 0x63, 0xE4 },
        { 0xB2, 0x00 },
        { 0x40, 0x00 },
        { 0xB5, 0x00 },
        { 0x63, 0xE4 },
        { 0xB5, 0x00 },
        { 0x40, 0x04 },
        { 0xB1, 0x00 },
        { 0x61, 0x78 },
        { 0xB1, 0x00 },
        { 0x40, 0x04 },
        { 0xB4, 0x01 },
        { 0x00, 0x08 },
        { 0xB4, 0x00 },
// page 158 (0x9E)
    { 0x00, 0x9E },
    { CFG_META_BURST, 0x79 },
        { 0x08, 0x00 },
        { 0x61, 0x78 },
        { 0xB4, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x01 },
        { 0x10, 0x0C },
        { 0x02, 0x00 },
        { 0x40, 0x00 },
        { 0xB1, 0x01 },
        { 0x10, 0x00 },
        { 0x02, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x61, 0x78 },
        { 0xB1, 0x01 },
        { 0x03, 0xDB },
        { 0xFB, 0x01 },
        { 0x01, 0x7F },
        { 0xFB, 0x01 },
        { 0x00, 0x0B },
        { 0xFB, 0x01 },
        { 0x10, 0x10 },
        { 0x07, 0x01 },
        { 0x10, 0x10 },
        { 0x02, 0x01 },
        { 0x10, 0x0C },
        { 0x03, 0x01 },
        { 0x10, 0x00 },
        { 0x03, 0x00 },
        { 0x91, 0x78 },
        { 0x02, 0x01 },
        { 0x10, 0x00 },
        { 0x01, 0x00 },
        { 0x91, 0x78 },
        { 0x3E, 0x01 },
        { 0x10, 0x00 },
        { 0x0B, 0x01 },
        { 0x03, 0xDF },
        { 0xFB, 0x01 },
        { 0x03, 0xE3 },
        { 0xFB, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x01 },
        { 0x10, 0x10 },
        { 0x03, 0x01 },
        { 0x10, 0x0C },
        { 0x04, 0x00 },
        { 0x91, 0x78 },
        { 0x06, 0x01 },
        { 0x10, 0x00 },
        { 0x04, 0x00 },
        { 0x91, 0x78 },
        { 0x08, 0x01 },
        { 0x10, 0x00 },
        { 0x01, 0x00 },
        { 0x91, 0x78 },
        { 0x04, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
// page 159 (0x9F)
    { 0x00, 0x9F },
    { CFG_META_BURST, 0x79 },
        { 0x08, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x83, 0xD4 },
        { 0x00, 0x00 },
        { 0x93, 0xC4 },
        { 0x00, 0x00 },
        { 0x73, 0x8F },
        { 0xFB, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x93, 0xD4 },
        { 0x02, 0x00 },
        { 0x73, 0x8B },
        { 0xFB, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x93, 0xD4 },
        { 0x02, 0x00 },
        { 0x73, 0x87 },
        { 0xFB, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x93, 0xD4 },
        { 0x02, 0x00 },
        { 0x73, 0x73 },
        { 0xFB, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x93, 0xD4 },
        { 0x02, 0x00 },
        { 0x73, 0x6F },
        { 0xFB, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x93, 0xD4 },
        { 0x02, 0x00 },
        { 0x73, 0x6B },
        { 0xFB, 0x00 },
        { 0x61, 0x78 },
        { 0xB1, 0x01 },
        { 0x03, 0xDB },
        { 0xFB, 0x00 },
        { 0x40, 0x00 },
        { 0xBB, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x01 },
        { 0x10, 0x10 },
        { 0x0B, 0x01 },
        { 0x01, 0x7F },
        { 0xFB, 0x01 },
        { 0x00, 0x0B },
        { 0xFB, 0x00 },
        { 0x61, 0x78 },
        { 0xBB, 0x01 },
        { 0x10, 0x10 },
        { 0x02, 0x01 },
        { 0x10, 0x0C },
        { 0x03, 0x01 },
        { 0x10, 0x00 },
        { 0x03, 0x00 },
// page 160 (0xA0)
    { 0x00, 0xA0 },
    { CFG_META_BURST, 0x79 },
        { 0x08, 0x00 },
        { 0x93, 0xC8 },
        { 0x02, 0x01 },
        { 0x10, 0x00 },
        { 0x01, 0x00 },
        { 0x93, 0xCC },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x01 },
        { 0x10, 0x00 },
        { 0x0D, 0x01 },
        { 0x03, 0xDF },
        { 0xFB, 0x01 },
        { 0x03, 0xE3 },
        { 0xFB, 0x00 },
        { 0x61, 0x78 },
        { 0xBB, 0x01 },
        { 0x10, 0x10 },
        { 0x05, 0x01 },
        { 0x10, 0x0C },
        { 0x02, 0x00 },
        { 0x93, 0xD0 },
        { 0x05, 0x01 },
        { 0x10, 0x00 },
        { 0x05, 0x00 },
        { 0x91, 0x78 },
        { 0x03, 0x01 },
        { 0x10, 0x00 },
        { 0x03, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x91, 0x78 },
        { 0x06, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x91, 0x40 },
        { 0x01, 0x00 },
        { 0x60, 0x08 },
        { 0xB1, 0x01 },
        { 0x01, 0x2F },
        { 0xFB, 0x00 },
        { 0x40, 0x00 },
        { 0xBB, 0x00 },
        { 0x61, 0x83 },
        { 0xFB, 0x00 },
        { 0x60, 0x0C },
        { 0xBB, 0x01 },
        { 0x10, 0x10 },
        { 0x02, 0x00 },
        { 0x40, 0x04 },
        { 0xB9, 0x01 },
        { 0x10, 0x00 },
        { 0x02, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x40, 0x04 },
        { 0xB9, 0x00 },
        { 0x62, 0x94 },
        { 0xB8, 0x00 },
// page 161 (0xA1)
    { 0x00, 0xA1 },
    { CFG_META_BURST, 0x79 },
        { 0x08, 0x01 },
        { 0x00, 0x0C },
        { 0xB9, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x61, 0x34 },
        { 0xB8, 0x01 },
        { 0x10, 0x0C },
        { 0x02, 0x00 },
        { 0x71, 0x30 },
        { 0xB9, 0x01 },
        { 0x10, 0x00 },
        { 0x02, 0x00 },
        { 0x61, 0x3C },
        { 0xB8, 0x00 },
        { 0x71, 0x38 },
        { 0xB9, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x81, 0x74 },
        { 0x00, 0x00 },
        { 0x61, 0x74 },
        { 0xAD, 0x00 },
        { 0x61, 0x74 },
        { 0xAE, 0x00 },
        { 0x40, 0x00 },
        { 0xB7, 0x00 },
        { 0x40, 0x24 },
        { 0xAF, 0x00 },
        { 0x40, 0x24 },
        { 0xB0, 0x00 },
        { 0x63, 0x60 },
        { 0x83, 0x00 },
        { 0x73, 0x64 },
        { 0xAF, 0x00 },
        { 0x63, 0x60 },
        { 0xB0, 0x00 },
        { 0x73, 0x64 },
        { 0x96, 0x00 },
        { 0x40, 0x00 },
        { 0xBC, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x40, 0x00 },
        { 0xBD, 0x00 },
        { 0x60, 0x0C },
        { 0xBC, 0x00 },
        { 0x61, 0x8C },
        { 0xC0, 0x01 },
        { 0xB1, 0x88 },
        { 0xBF, 0x00 },
        { 0x40, 0x04 },
        { 0xBE, 0x00 },
        { 0x71, 0x84 },
        { 0xBE, 0x01 },
        { 0xB1, 0x90 },
        { 0xC2, 0x00 },
        { 0x71, 0x94 },
        { 0xC3, 0x00 },
// page 162 (0xA2)
    { 0x00, 0xA2 },
    { CFG_META_BURST, 0x79 },
        { 0x08, 0x00 },
        { 0x61, 0xA0 },
        { 0xC3, 0x01 },
        { 0xB1, 0x9C },
        { 0xC2, 0x01 },
        { 0x31, 0x98 },
        { 0xC1, 0x01 },
        { 0xB1, 0xA4 },
        { 0xC5, 0x00 },
        { 0x71, 0xA8 },
        { 0xC6, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x40, 0x00 },
        { 0xC4, 0x00 },
        { 0x61, 0xAF },
        { 0xFB, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x40, 0x00 },
        { 0xC8, 0x00 },
        { 0x60, 0x0C },
        { 0xC4, 0x01 },
        { 0x00, 0x20 },
        { 0xC8, 0x01 },
        { 0x00, 0x0C },
        { 0xC8, 0x00 },
        { 0x60, 0x0C },
        { 0xC4, 0x01 },
        { 0x10, 0x0C },
        { 0x02, 0x01 },
        { 0x10, 0x10 },
        { 0x04, 0x01 },
        { 0x10, 0x00 },
        { 0x04, 0x00 },
        { 0x60, 0x0C },
        { 0xC8, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x01 },
        { 0x10, 0x00 },
        { 0x02, 0x00 },
        { 0x60, 0x20 },
        { 0xC8, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x40, 0x04 },
        { 0xC9, 0x00 },
        { 0x60, 0x0C },
        { 0xC9, 0x00 },
        { 0x61, 0xB8 },
        { 0xCC, 0x01 },
        { 0xB1, 0xB4 },
        { 0xCB, 0x00 },
        { 0x40, 0x04 },
        { 0xCA, 0x00 },
// page 163 (0xA3)
    { 0x00, 0xA3 },
    { CFG_META_BURST, 0x79 },
        { 0x08, 0x00 },
        { 0x71, 0xB0 },
        { 0xCA, 0x01 },
        { 0xB1, 0xBC },
        { 0xCE, 0x00 },
        { 0x71, 0xC0 },
        { 0xCF, 0x00 },
        { 0x61, 0xCC },
        { 0xCF, 0x01 },
        { 0xB1, 0xC8 },
        { 0xCE, 0x01 },
        { 0x31, 0xC4 },
        { 0xCD, 0x01 },
        { 0xB1, 0xD0 },
        { 0xD1, 0x00 },
        { 0x71, 0xD4 },
        { 0xD2, 0x00 },
        { 0x61, 0xE0 },
        { 0xD2, 0x01 },
        { 0xB1, 0xDC },
        { 0xD1, 0x01 },
        { 0x31, 0xD8 },
        { 0xD0, 0x01 },
        { 0xB1, 0xE4 },
        { 0xD4, 0x00 },
        { 0x71, 0xE8 },
        { 0xD5, 0x00 },
        { 0x61, 0xF4 },
        { 0xD5, 0x01 },
        { 0xB1, 0xF0 },
        { 0xD4, 0x01 },
        { 0x31, 0xEC },
        { 0xD3, 0x01 },
        { 0xB1, 0xF8 },
        { 0xD7, 0x00 },
        { 0x71, 0xFC },
        { 0xD8, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x40, 0x00 },
        { 0xD6, 0x00 },
        { 0x60, 0x0C },
        { 0xBD, 0x00 },
        { 0x62, 0x0C },
        { 0xDB, 0x01 },
        { 0xB2, 0x08 },
        { 0xDA, 0x00 },
        { 0x40, 0x04 },
        { 0xD9, 0x00 },
        { 0x72, 0x04 },
        { 0xD9, 0x01 },
        { 0xB2, 0x10 },
        { 0xDD, 0x00 },
        { 0x72, 0x14 },
        { 0xDE, 0x00 },
        { 0x62, 0x20 },
        { 0xDE, 0x01 },
        { 0xB2, 0x1C },
        { 0xDD, 0x00 },
// page 164 (0xA4)
    { 0x00, 0xA4 },
    { CFG_META_BURST, 0x79 },
        { 0x08, 0x01 },
        { 0x32, 0x18 },
        { 0xDC, 0x01 },
        { 0xB2, 0x24 },
        { 0xE0, 0x00 },
        { 0x72, 0x28 },
        { 0xE1, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x40, 0x00 },
        { 0xDF, 0x00 },
        { 0x60, 0x0C },
        { 0xBD, 0x00 },
        { 0x61, 0x8C },
        { 0xE4, 0x01 },
        { 0xB1, 0x88 },
        { 0xE3, 0x00 },
        { 0x40, 0x04 },
        { 0xE2, 0x00 },
        { 0x71, 0x84 },
        { 0xE2, 0x01 },
        { 0xB1, 0x90 },
        { 0xE6, 0x00 },
        { 0x71, 0x94 },
        { 0xE7, 0x00 },
        { 0x61, 0xA0 },
        { 0xE7, 0x01 },
        { 0xB1, 0x9C },
        { 0xE6, 0x01 },
        { 0x31, 0x98 },
        { 0xE5, 0x01 },
        { 0xB1, 0xA4 },
        { 0xE9, 0x00 },
        { 0x71, 0xA8 },
        { 0xEA, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x40, 0x00 },
        { 0xE8, 0x00 },
        { 0x60, 0x0C },
        { 0xE8, 0x01 },
        { 0x00, 0x20 },
        { 0xC8, 0x01 },
        { 0x00, 0x0C },
        { 0xC8, 0x00 },
        { 0x60, 0x0C },
        { 0xE8, 0x01 },
        { 0x10, 0x0C },
        { 0x02, 0x01 },
        { 0x10, 0x10 },
        { 0x04, 0x01 },
        { 0x10, 0x00 },
        { 0x04, 0x00 },
        { 0x60, 0x0C },
        { 0xC8, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
// page 165 (0xA5)
    { 0x00, 0xA5 },
    { CFG_META_BURST, 0x79 },
        { 0x08, 0x01 },
        { 0x10, 0x00 },
        { 0x02, 0x00 },
        { 0x60, 0x20 },
        { 0xC8, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x40, 0x04 },
        { 0xEB, 0x00 },
        { 0x60, 0x0C },
        { 0xEB, 0x00 },
        { 0x61, 0xB8 },
        { 0xEE, 0x01 },
        { 0xB1, 0xB4 },
        { 0xED, 0x00 },
        { 0x40, 0x04 },
        { 0xEC, 0x00 },
        { 0x71, 0xB0 },
        { 0xEC, 0x01 },
        { 0xB1, 0xBC },
        { 0xF0, 0x00 },
        { 0x71, 0xC0 },
        { 0xF1, 0x00 },
        { 0x61, 0xCC },
        { 0xF1, 0x01 },
        { 0xB1, 0xC8 },
        { 0xF0, 0x01 },
        { 0x31, 0xC4 },
        { 0xEF, 0x01 },
        { 0xB1, 0xD0 },
        { 0xF3, 0x00 },
        { 0x71, 0xD4 },
        { 0xF4, 0x00 },
        { 0x61, 0xE0 },
        { 0xF4, 0x01 },
        { 0xB1, 0xDC },
        { 0xF3, 0x01 },
        { 0x31, 0xD8 },
        { 0xF2, 0x01 },
        { 0xB1, 0xE4 },
        { 0xF6, 0x00 },
        { 0x71, 0xE8 },
        { 0xF7, 0x00 },
        { 0x61, 0xF4 },
        { 0xF7, 0x01 },
        { 0xB1, 0xF0 },
        { 0xF6, 0x01 },
        { 0x31, 0xEC },
        { 0xF5, 0x01 },
        { 0xB1, 0xF8 },
        { 0xF9, 0x00 },
        { 0x71, 0xFC },
        { 0xFA, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x40, 0x00 },
        { 0xF8, 0x00 },
// page 166 (0xA6)
    { 0x00, 0xA6 },
    { CFG_META_BURST, 0x79 },
        { 0x08, 0x00 },
        { 0x62, 0x00 },
        { 0xD6, 0x00 },
        { 0x62, 0x00 },
        { 0xF8, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x40, 0x18 },
        { 0xFB, 0x00 },
        { 0x40, 0x18 },
        { 0xFC, 0x00 },
        { 0x60, 0x0C },
        { 0xBC, 0x00 },
        { 0x62, 0x0C },
        { 0xFF, 0x01 },
        { 0xB2, 0x08 },
        { 0xFE, 0x00 },
        { 0x40, 0x04 },
        { 0xFD, 0x00 },
        { 0x72, 0x04 },
        { 0xFD, 0x01 },
        { 0xB2, 0x11 },
        { 0x01, 0x00 },
        { 0x72, 0x15 },
        { 0x02, 0x00 },
        { 0x62, 0x21 },
        { 0x02, 0x01 },
        { 0xB2, 0x1D },
        { 0x01, 0x01 },
        { 0x32, 0x19 },
        { 0x00, 0x01 },
        { 0xB2, 0x25 },
        { 0x04, 0x00 },
        { 0x72, 0x29 },
        { 0x05, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x40, 0x01 },
        { 0x03, 0x00 },
        { 0x60, 0x0D },
        { 0x03, 0x00 },
        { 0x70, 0x0C },
        { 0xFB, 0x00 },
        { 0x60, 0x0C },
        { 0xFC, 0x00 },
        { 0x70, 0x0C },
        { 0xDF, 0x00 },
        { 0x40, 0x05 },
        { 0x06, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x40, 0x05 },
        { 0x07, 0x00 },
        { 0x62, 0x2D },
        { 0x06, 0x00 },
        { 0x62, 0x2D },
        { 0x07, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
// page 167 (0xA7)
    { 0x00, 0xA7 },
    { CFG_META_BURST, 0x79 },
        { 0x08, 0x00 },
        { 0x40, 0x11 },
        { 0x08, 0x00 },
        { 0x40, 0x11 },
        { 0x09, 0x00 },
        { 0x63, 0x7D },
        { 0x08, 0x00 },
        { 0x73, 0x80 },
        { 0x4E, 0x00 },
        { 0x63, 0x7D },
        { 0x09, 0x00 },
        { 0x73, 0x80 },
        { 0x70, 0x00 },
        { 0x40, 0x01 },
        { 0x0A, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x00 },
        { 0x40, 0x01 },
        { 0x0B, 0x00 },
        { 0x61, 0x05 },
        { 0x0A, 0x00 },
        { 0x61, 0x05 },
        { 0x0B, 0x00 },
        { 0x21, 0xEC },
        { 0xDE, 0x00 },
        { 0x40, 0x05 },
        { 0x0C, 0x00 },
        { 0x40, 0x05 },
        { 0x0D, 0x00 },
        { 0x21, 0xF0 },
        { 0xDD, 0x01 },
        { 0x14, 0x81 },
        { 0x80, 0x00 },
        { 0x60, 0x0D },
        { 0x0E, 0x00 },
        { 0x60, 0x0D },
        { 0x0F, 0x00 },
        { 0x21, 0xF0 },
        { 0xFB, 0x00 },
        { 0x40, 0x05 },
        { 0x28, 0x00 },
        { 0x40, 0x05 },
        { 0x74, 0x01 },
        { 0x14, 0x83 },
        { 0xCC, 0x00 },
        { 0x21, 0xF0 },
        { 0xFC, 0x01 },
        { 0x14, 0x83 },
        { 0xCC, 0x00 },
        { 0x6F, 0xED },
        { 0x1F, 0x00 },
        { 0x6F, 0xED },
        { 0x20, 0x00 },
        { 0x30, 0x00 },
        { 0x02, 0x00 },
        { 0x30, 0x00 },
        { 0x02, 0x00 },
        { 0x6F, 0xED },
        { 0x21, 0x00 },
        { 0x6F, 0xED },
        { 0x22, 0x00 },
// page 168 (0xA8)
    { 0x00, 0xA8 },
    { CFG_META_BURST, 0x79 },
        { 0x08, 0x00 },
        { 0x30, 0x00 },
        { 0x02, 0x00 },
        { 0x30, 0x00 },
        { 0x02, 0x00 },
        { 0x6F, 0xED },
        { 0x23, 0x00 },
        { 0x6F, 0xED },
        { 0x24, 0x00 },
        { 0x30, 0x00 },
        { 0x02, 0x00 },
        { 0x30, 0x00 },
        { 0x02, 0x00 },
        { 0x6F, 0xED },
        { 0x25, 0x00 },
        { 0x6F, 0xED },
        { 0x26, 0x00 },
        { 0x30, 0x00 },
        { 0x02, 0x00 },
        { 0x30, 0x00 },
        { 0x02, 0x00 },
        { 0x6F, 0xF1 },
        { 0x6B, 0x00 },
        { 0x6F, 0xF1 },
        { 0x6C, 0x00 },
        { 0x30, 0x04 },
        { 0x02, 0x00 },
        { 0x30, 0x04 },
        { 0x02, 0x00 },
        { 0x6F, 0xF1 },
        { 0x6D, 0x00 },
        { 0x6F, 0xF1 },
        { 0x6E, 0x00 },
        { 0x30, 0x04 },
        { 0x02, 0x00 },
        { 0x30, 0x04 },
        { 0x02, 0x00 },
        { 0x6F, 0xF1 },
        { 0x6F, 0x00 },
        { 0x6F, 0xF1 },
        { 0x70, 0x00 },
        { 0x30, 0x04 },
        { 0x02, 0x00 },
        { 0x30, 0x04 },
        { 0x02, 0x00 },
        { 0x6F, 0xF1 },
        { 0x71, 0x00 },
        { 0x6F, 0xF1 },
        { 0x72, 0x00 },
        { 0x30, 0x04 },
        { 0x02, 0x00 },
        { 0x30, 0x04 },
        { 0x02, 0x00 },
        { 0x60, 0x11 },
        { 0x0E, 0x00 },
        { 0x60, 0x11 },
        { 0x0F, 0x00 },
        { 0x30, 0x48 },
        { 0x02, 0x00 },
        { 0x30, 0x4C },
        { 0x02, 0x00 },
// page 169 (0xA9)
    { 0x00, 0xA9 },
    { CFG_META_BURST, 0x79 },
        { 0x08, 0x01 },
        { 0x10, 0x03 },
        { 0xFF, 0x00 },
        { 0xA3, 0x64 },
        { 0xAD, 0x00 },
        { 0x10, 0x00 },
        { 0x00, 0x00 },
        { 0x10, 0x04 },
        { 0x01, 0x00 },
        { 0x60, 0x03 },
        { 0xFB, 0x01 },
        { 0x00, 0x20 },
        { 0x09, 0x00 },
        { 0x70, 0x20 },
        { 0x05, 0x00 },
        { 0x40, 0x04 },
        { 0x08, 0x01 },
        { 0x10, 0x04 },
        { 0x01, 0x01 },
        { 0x10, 0x00 },
        { 0x01, 0x00 },
        { 0x40, 0xDC },
        { 0x07, 0x00 },
        { 0x60, 0x0C },
        { 0x05, 0x00 },
        { 0x70, 0x0C },
        { 0x07, 0x00 },
        { 0x70, 0x20 },
        { 0x08, 0x00 },
        { 0x60, 0x0C },
        { 0x07, 0x00 },
        { 0x40, 0x04 },
        { 0x04, 0x00 },
        { 0x80, 0x18 },
        { 0x01, 0x00 },
        { 0x40, 0x04 },
        { 0x06, 0x00 },
        { 0x60, 0x18 },
        { 0x06, 0x00 },
        { 0x60, 0x17 },
        { 0xFB, 0x00 },
        { 0x60, 0x0C },
        { 0x08, 0x01 },
        { 0x10, 0x14 },
        { 0x02, 0x00 },
        { 0x00, 0x00 },
        { 0x00, 0x01 },
        { 0x10, 0x00 },
        { 0x02, 0x00 },
        { 0x40, 0x04 },
        { 0x06, 0x00 },
        { 0x40, 0x04 },
        { 0x04, 0x00 },
        { 0x60, 0x0C },
        { 0x0E, 0x00 },
        { 0x60, 0x0C },
        { 0x13, 0x00 },
        { 0x60, 0x08 },
        { 0x00, 0x00 },
        { 0x40, 0x04 },
        { 0x0D, 0x00 },
// Command Dump Configuration
//-------------------------------------------------
// Project: PurePath� Smart Amp for Laptops
// SA Plug-in Version: TAS5766MDCAEVM v4.0010
// Block: Basic Mode
// Version: 20141008
//-------------------------------------------------
//
//-------------------------------------------------
// Select DSP Mode 1
//-------------------------------------------------
// Select Page 0
    { 0x00, 0x00 },
// DSP Program = Mode 1
    { 0x2B, 0x01 },
// Digital Volume Control
// *Configure based on speaker power handling*
// See Smart Amp Design Guide
    { 0x3D, 0x30 },
    { 0x3E, 0x30 },
// Select Page 44
    { 0x00, 0x2C },
// Disable miniDSP_D Adaptive Mode
    { 0x01, 0x00 },
// Command Dump Configuration
//-------------------------------------------------
// Project: PurePath� Smart Amp for Laptops
// SA Plug-in Version: TAS5766MDCAEVM v4.0010
// Block: Config
// Version: 20141008
//-------------------------------------------------
//
//-------------------------------------------------
// Post-configuration
//-------------------------------------------------
// Select Page 1
    { 0x00, 0x01 },
// Charge Pump Delay = 165ns
    { 0x03, 0x04 },
// Select Page 0
    { 0x00, 0x00 },
// PLL reference clock = BCK (no SCK present)
    { 0x0D, 0x10 },
// Ignore SCK halt detection (no SCK present)
    { 0x25, 0x08 },
// Fast BG ramp-up
    { 0x08, 0x10 },
// Command Dump Configuration
//-------------------------------------------------
// Project: PurePath� Smart Amp for Laptops
// SA Plug-in Version: TAS5766MDCAEVM v4.0010
// Block: Wake
// Version: 20141008
//-------------------------------------------------
//
//-------------------------------------------------
// Wake
//-------------------------------------------------
// Select Page 0
    { 0x00, 0x00 },
// Wake from Standby
    { 0x02, 0x00 },
// Unmute L/R
    { 0x03, 0x00 },
};
